/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class AlbumArtPanel
extends JPanel {
    private BufferedImage albumArt;

    public AlbumArtPanel(File mp3File) {
        this.setPreferredSize(new Dimension(400, 400));
        this.loadAlbumArt(mp3File);
    }

    private void loadAlbumArt(File mp3File) {
        try {
            File imgFile = new File(mp3File.getParentFile(), mp3File.getName().replaceAll("\\.mp3$", ".jpg"));
            if (!imgFile.exists()) {
                imgFile = new File(mp3File.getParentFile(), mp3File.getName().replaceAll("\\.mp3$", ".png"));
            }
            if (imgFile.exists()) {
                this.albumArt = ImageIO.read(imgFile);
            }
        }
        catch (Exception e) {
            System.out.println("No album art found for " + mp3File.getName());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.albumArt != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.drawImage(this.albumArt, 0, 0, w, h, this);
        } else {
            g.setColor(Color.DARK_GRAY);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

