/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PlayerUI {
    private MediaPlayer mediaPlayer;
    private MediaView mediaView;
    private JFrame frame;
    private JFXPanel jfxPanel;
    private boolean isSeeking = false;
    private static final int MAX_RECENT_FILES = 5;
    private final Preferences prefs = Preferences.userNodeForPackage(PlayerUI.class);
    private final ArrayList<Object> recentFiles = new ArrayList();
    private final JMenu recentFilesMenu = new JMenu("Recent Files");
    private boolean isFullscreen = false;
    private Rectangle previousBounds;
    private JLabel fileLabel;
    private JLabel timeLabel;
    private JSlider seekBar;

    public void createAndShowGUI() {
        this.frame = new JFrame("Viewed - V0.2 (Ready for liftoff)");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(900, 700);
        this.frame.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem openItem = new JMenuItem("Open Audio/Video file...");
        JMenuItem exitItem = new JMenuItem("Exit");
        fileMenu.add(openItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        fileMenu.add(this.recentFilesMenu);
        JMenu viewMenu = new JMenu("View");
        JMenuItem fullscreenItem = new JMenuItem("Toggle Fullscreen");
        viewMenu.add(fullscreenItem);
        JMenu playbackMenu = new JMenu("Playback");
        JMenuItem reloadItem = new JMenuItem("Reload Player");
        playbackMenu.add(reloadItem);
        JMenu toolsMenu = new JMenu("Help");
        JMenuItem aboutItem = new JMenuItem("About");
        JMenuItem nothingItem = new JMenuItem("Help");
        toolsMenu.add(aboutItem);
        toolsMenu.add(nothingItem);
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        menuBar.add(playbackMenu);
        menuBar.add(toolsMenu);
        this.frame.setJMenuBar(menuBar);
        this.jfxPanel = new JFXPanel();
        this.frame.add((Component)this.jfxPanel, "Center");
        this.fileLabel = new JLabel("No media loaded :(");
        this.fileLabel.setHorizontalAlignment(0);
        this.fileLabel.setVerticalAlignment(0);
        this.fileLabel.setFont(new Font("SansSerif", 1, 24));
        this.jfxPanel.setLayout((LayoutManager)new BorderLayout());
        this.jfxPanel.add((Component)this.fileLabel, (Object)"Center");
        JPanel controls = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JButton playBtn = new JButton("\u25b6 Play");
        JButton pauseBtn = new JButton("\u23f8 Pause");
        buttonPanel.add(playBtn);
        buttonPanel.add(pauseBtn);
        JPanel volumePanel = new JPanel();
        this.timeLabel = new JLabel("00:00 / 00:00");
        JSlider volumeSlider = new JSlider(0, 100, 100);
        volumePanel.add(new JLabel("\ud83d\udd0a"));
        volumePanel.add(volumeSlider);
        volumePanel.add(this.timeLabel);
        controls.add((Component)buttonPanel, "West");
        controls.add((Component)volumePanel, "East");
        this.frame.add((Component)controls, "South");
        this.seekBar = new JSlider(0, 100, 0);
        this.frame.add((Component)this.seekBar, "North");
        this.frame.setVisible(true);
        openItem.addActionListener(e -> this.chooseFile());
        exitItem.addActionListener(e -> System.exit(0));
        fullscreenItem.addActionListener(e -> this.toggleFullscreen());
        reloadItem.addActionListener(e -> {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.stop();
                this.mediaPlayer.dispose();
            }
            JOptionPane.showMessageDialog(this.frame, "Player reloaded!");
        });
        aboutItem.addActionListener(e -> new About().run());
        nothingItem.addActionListener(e -> JOptionPane.showMessageDialog(this.frame, "Help not available yet."));
        playBtn.addActionListener(e -> Platform.runLater(() -> {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.play();
            }
        }));
        pauseBtn.addActionListener(e -> Platform.runLater(() -> {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.pause();
            }
        }));
        volumeSlider.addChangeListener(e -> {
            if (this.mediaPlayer != null && !volumeSlider.getValueIsAdjusting()) {
                Platform.runLater(() -> this.mediaPlayer.setVolume((double)volumeSlider.getValue() / 100.0));
            }
        });
        this.seekBar.addChangeListener(e -> {
            if (this.mediaPlayer == null) {
                return;
            }
            if (this.seekBar.getValueIsAdjusting()) {
                this.isSeeking = true;
                double percent = (double)this.seekBar.getValue() / 100.0;
                Platform.runLater(() -> {
                    Duration total = this.mediaPlayer.getTotalDuration();
                    if (total != null && !total.isUnknown()) {
                        this.mediaPlayer.seek(total.multiply(percent));
                    }
                });
            } else {
                this.isSeeking = false;
            }
        });
        this.loadRecentFiles();
    }

    private void chooseFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select a media file");
        chooser.setFileFilter(new FileNameExtensionFilter("Audio/Video Files", "mp4", "m4v", "mp3", "wav", "aac", "aiff"));
        int result = chooser.showOpenDialog(this.frame);
        if (result != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String path = file.getAbsolutePath().toLowerCase();
        if (path.endsWith(".mp4") || path.endsWith(".m4v")) {
            this.openMediaFile(file);
        } else if (path.endsWith(".mp3") || path.endsWith(".wav") || path.endsWith(".aiff") || path.endsWith(".aac")) {
            this.openAudio(file);
        } else {
            JOptionPane.showMessageDialog(this.frame, "Unsupported file type!");
        }
    }

    private void openMediaFile(File file) {
        if (file == null) {
            return;
        }
        Platform.runLater(() -> {
            try {
                Media media = new Media(file.toURI().toString());
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.stop();
                    this.mediaPlayer.dispose();
                }
                this.mediaPlayer = new MediaPlayer(media);
                if (this.mediaView == null) {
                    this.mediaView = new MediaView(this.mediaPlayer);
                } else {
                    this.mediaView.setMediaPlayer(this.mediaPlayer);
                }
                StackPane root = new StackPane(new Node[]{this.mediaView});
                this.mediaView.setPreserveRatio(true);
                this.mediaView.fitWidthProperty().bind((ObservableValue)root.widthProperty());
                this.mediaView.fitHeightProperty().bind((ObservableValue)root.heightProperty());
                Scene scene = new Scene((Parent)root, 800.0, 600.0, (Paint)Color.BLACK);
                this.jfxPanel.setScene(scene);
                this.fileLabel.setVisible(false);
                this.mediaPlayer.play();
                this.addRecentFile(file.getAbsolutePath());
                this.setupTimeListener();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.frame, "Could not open file:\n" + file.getName() + "\n" + e.getMessage());
            }
        });
    }

    private void openAudio(File file) {
        if (file == null) {
            return;
        }
        Platform.runLater(() -> {
            try {
                Media media = new Media(file.toURI().toString());
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.stop();
                    this.mediaPlayer.dispose();
                }
                this.mediaPlayer = new MediaPlayer(media);
                this.mediaPlayer.play();
                this.fileLabel.setText(file.getName());
                this.fileLabel.setVisible(true);
                this.addRecentFile(file.getAbsolutePath());
                this.setupTimeListener();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.frame, "Could not open audio:\n" + file.getName() + "\n" + e.getMessage());
            }
        });
    }

    private void setupTimeListener() {
        if (this.mediaPlayer == null) {
            return;
        }
        this.mediaPlayer.currentTimeProperty().addListener((obs, oldTime, newTime) -> Platform.runLater(() -> {
            Duration total = this.mediaPlayer.getTotalDuration();
            if (total != null && !total.isUnknown()) {
                this.timeLabel.setText(this.formatTime((Duration)newTime) + " / " + this.formatTime(total));
                if (!this.isSeeking) {
                    double progress = newTime.toMillis() / total.toMillis() * 100.0;
                    this.seekBar.setValue((int)progress);
                }
            }
        }));
    }

    private void toggleFullscreen() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!this.isFullscreen) {
            this.previousBounds = this.frame.getBounds();
            this.frame.dispose();
            this.frame.setUndecorated(true);
            this.frame.setVisible(true);
            gd.setFullScreenWindow(this.frame);
            this.isFullscreen = true;
        } else {
            gd.setFullScreenWindow(null);
            this.frame.dispose();
            this.frame.setUndecorated(false);
            this.frame.setBounds(this.previousBounds);
            this.frame.setVisible(true);
            this.isFullscreen = false;
        }
    }

    private void loadRecentFiles() {
        this.recentFiles.clear();
        for (int i = 0; i <= 5; ++i) {
            String path = this.prefs.get("recentFile" + i, null);
            if (path == null) continue;
            this.recentFiles.add(path);
        }
        this.refreshRecentFilesMenu();
    }

    private void addRecentFile(String path) {
        this.recentFiles.removeIf(obj -> obj instanceof String && obj.equals(path));
        this.recentFiles.add(0, path);
        while (this.recentFiles.size() > 5) {
            this.recentFiles.remove(this.recentFiles.size() - 1);
        }
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            Object obj2 = this.recentFiles.get(i);
            if (!(obj2 instanceof String)) continue;
            String s = (String)obj2;
            this.prefs.put("recentFile" + i, s);
        }
        this.refreshRecentFilesMenu();
    }

    private void refreshRecentFilesMenu() {
        this.recentFilesMenu.removeAll();
        boolean hasFiles = false;
        for (Object obj : this.recentFiles) {
            if (!(obj instanceof String)) continue;
            String path = (String)obj;
            JMenuItem item = new JMenuItem(path);
            item.addActionListener(e -> {
                File file = new File(path);
                if (path.endsWith(".mp4") || path.endsWith(".m4v")) {
                    this.openMediaFile(file);
                } else {
                    this.openAudio(file);
                }
            });
            this.recentFilesMenu.add(item);
            hasFiles = true;
        }
        if (!hasFiles) {
            JMenuItem empty = new JMenuItem("No recent files :(");
            empty.setEnabled(false);
            this.recentFilesMenu.add(empty);
        }
    }

    private String formatTime(Duration duration) {
        if (duration == null || duration.isUnknown()) {
            return "00:00";
        }
        int totalSeconds = (int)Math.floor(duration.toSeconds());
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return new DecimalFormat("00").format(minutes) + ":" + new DecimalFormat("00").format(seconds);
    }
}

